#ifdef GL_ES
precision mediump float;
#endif

// output from the vertex shader (fragment color and texture coordinates)
varying vec4 v_fragmentColor;
varying vec2 v_texCoord;

uniform vec2 u_texture_steps;
const float dist_f = 1.25;


float get_a(vec2 offset) {
	float a = texture2D(CC_Texture0, v_texCoord + offset).a;
	a = floor(a);
	return a;
}


float compute_border() {
	float sx = u_texture_steps.x * dist_f;
	float sy = u_texture_steps.y * dist_f;
	float a = 0.0;

	// 1
	a += get_a(vec2(0.0, +sy));
	a += get_a(vec2(0.0, -sy));
	a += get_a(vec2(+sx, 0.0));
	a += get_a(vec2(-sx, 0.0));

	// 2
	a += get_a(vec2(sx *  0.00000000, sy *  2.00000000));
	a += get_a(vec2(sx *  1.41421356, sy *  1.41421356));
	a += get_a(vec2(sx *  2.00000000, sy *  0.00000000));
	a += get_a(vec2(sx *  1.41421356, sy * -1.41421356));
	a += get_a(vec2(sx *  0.00000000, sy * -2.00000000));
	a += get_a(vec2(sx * -1.41421356, sy * -1.41421356));
	a += get_a(vec2(sx * -2.00000000, sy *  0.00000000));
	a += get_a(vec2(sx * -1.41421356, sy *  1.41421356));

	// 3
	a += get_a(vec2(sx *  0.00000000, sy *  3.00000000));
	a += get_a(vec2(sx *  1.50000000, sy *  2.59807621));
	a += get_a(vec2(sx *  2.59807621, sy *  1.50000000));
	a += get_a(vec2(sx *  3.00000000, sy *  0.00000000));
	a += get_a(vec2(sx *  2.59807621, sy * -1.50000000));
	a += get_a(vec2(sx *  1.50000000, sy * -2.59807621));
	a += get_a(vec2(sx *  0.00000000, sy * -3.00000000));
	a += get_a(vec2(sx * -1.50000000, sy * -2.59807621));
	a += get_a(vec2(sx * -2.59807621, sy * -1.50000000));
	a += get_a(vec2(sx * -3.00000000, sy *  0.00000000));
	a += get_a(vec2(sx * -2.59807621, sy *  1.50000000));
	a += get_a(vec2(sx * -1.50000000, sy *  2.59807621));



	float max_sum = 24.0;
	float div     =  9.0;
	float f       = ((max_sum - a) / div);

	f = clamp(f, 0.0, 1.0);

	return f;
}


// main shader function
void main() {
	vec4 texel = texture2D(CC_Texture0, v_texCoord);

	float outline_intensity = compute_border();
	float texture_intensity = texel.a;
	outline_intensity *= texture_intensity;

	vec4 outline = v_fragmentColor * vec4(vec3(1.0), outline_intensity);

	gl_FragColor = outline;
}
